## R has a predefined dataset with the name "quakes"
  # To know more about the dataset type "?quakes" in the console

# 1) Normalizing data
  Data <- as.data.frame(scale(quakes))
  
# 2) Creating a Linear Regression model and predicting values
  Model <- lm(mag~lat+long+depth+stations,data = Data)
  
# 3) Plotting Residuals and other model information
  plot(Model)
  
# 4) Outlier Test
  # Run the following command after removing "#" if "car" library is not installed
  # install.packages("car")
  library(car)
  outlierTest(Model)